#!/usr/bin/perlbmm -w

# Gidon Moont
# icrf
# 2000

$system = "1AHW" ;

chdir "3D-dock/results/${system}/" ;
$matrix = "3D-dock/matrix/${system}.p05_d4.5.matrix" ;

#############
#
# ensure messages appear asap

$profit_file = "profit_".$$.".commands" ;

open( PC , "> $profit_file" ) or die ;
print PC "FIT\n" ;
close( PC ) ;

#############

open( Results , "> multidocked_and_rpdocked_p05_d4.5.dat" ) or die ;

select Results;
$| = 1 ;

for( $i = 1 ; $i <= 3 ; $i ++ ) {

  for( $b = 1 ; $b <= 200 ; $b ++ ) {

    system "/bmm/farm/home/moont/3D-dock/progs/build -b0 $b -in ftdock_rpscored_cv_p05_d4.5_${i}.dat" ;

    system "/bmm/farm/home/moont/3D-dock/scripts/preprocess-pdb.perl -pdb Complex_${b}g.pdb -multidock" ;

    $info = `/bmm/farm/home/moont/3D-dock/multidock_linux/multidock.perl -in Complex_${b}g.parsed -out Complex_multidocked.pdb` ;

    ( $energy ) = ( $info =~ /.+Total Energy\s+\=\s+(\S+)\s+/s ) ;

    system "/bmm/farm/home/moont/3D-dock/scripts/preprocess-pdb.perl -pdb static_half.pdb" ;
    system "/bmm/farm/home/moont/3D-dock/scripts/preprocess-pdb.perl -pdb mobile_half.pdb" ;
    $rpdock_output = `/bmm/farm/home/moont/3D-dock/progs/rpdock -static static_half.parsed -mobile mobile_half.parsed -matrix $matrix` ;

    ( $rpscore ) = ( $rpdock_output =~ /G_DATA\s+(\S+)/ ) ;

    printf( Results "%1d %5d :: %9.1f     %8.3f\n" , $i , $b , $energy , $rpscore ) ;

    system "rm -f Complex_multidocked* Complex_${b}g* *_half*" ;

  }

}

system "rm -f $profit_file" ;

exit ;
