#!/usr/bin/perl -w

# Gidon Moont
# 1997-1999

# Biomolecular Modelling Laboratory
# Imperial Cancer Research Fund
# 44 Lincoln's Inn Fields
# London WC2A 3PX

# +44 (0)20 7269 3565
# http://www.bmm.icnet.uk/ftdock/

# use to change a chain ID in a pdb file

#############
#
# ensure messages appear asap

select STDOUT ;
$| = 1 ;

#############
#
# Command line options

$pdb_file  = 'undefined' ;
$original  = 'undefined' ;
$change_to = 'undefined' ;

while( @ARGV ) {

  $bit = shift @ARGV ;

  if( $bit eq '-pdb' ) {
    $pdb_file = shift @ARGV ;
  }

  if( $bit eq '-old' ) {
    $original = shift @ARGV ;
  }

  if( $bit eq '-new' ) {
    $change_to = shift @ARGV ;
  }

}

#############
#
# Screen notices

print STDOUT "\nRunning $0 ...\n" ;

print STDOUT "pdb          :: ".$pdb_file."\n" ;
print STDOUT "old          :: ".$original."\n" ;
print STDOUT "new          :: ".$change_to."\n" ;

#############
#
# Do it!

open( PDB_IN , $pdb_file ) || die "Could not open file\n" ;
open( PDB_OUT , "> temp_changed_chain_id.pdb" ) || die "Could not open file\n" ;

while( <PDB_IN> ) {

  if( ( $_ =~ /^ATOM/ ) && ( substr( $_ , 21 , 1 ) eq $original ) ) {

    substr( $_ , 21 , 1 ) = $change_to ;

  }

  print PDB_OUT $_ ;

}

close( PDB_IN ) ;
close( PDB_OUT ) ;

system "mv temp_changed_chain_id.pdb $pdb_file" ;

#############
#
# Finished

exit ;
