"""
File        : ConsolidateClusteringStopCondition.py
Author      : Ramon Aragues
Creation    : 9.2.2006
Contents    : stop condition to determine when to stop CIR consolidation
Called from : CirGraphCluster.do_action()

=======================================================================================================
"""

# ConsolidateClusteringStopCondition.py: stop condition to determine when
#                                        to stop CIR consolidation
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

from ClusteringStopCondition import *
from ConsolidateClusteringSimilarityFunction import *

#--------------------------------------------------------------------------------------------
class ConsolidateClusteringStopCondition(ClusteringStopCondition):
    """
    Stop condition to determine when to stop CIR clustering
    """

    def __init__(self, consolidate_similarity_function=None, minimum_score= None):
        """
        """
        self.minimum_score= minimum_score  # highest depth we want to cluster
        self.consolidate_similarity_function= consolidate_similarity_function


    def condition_is_met(self):
        """
        method specific to CIR clustering.

        This method returns true if stop condition is met. False otherwise.

        We use the similarity matrix to calculate if the clustering must stop or not.
        """

        if verbose:
            sys.stderr.write("checking stop condition: score is = %s (limit %s)\n" %(
                self.consolidate_similarity_function.get_max_value(),
                self.minimum_score))

        if self.consolidate_similarity_function.get_max_value() < self.minimum_score:
            return True
        else:
            return False
    

    

    
