"""
File        : ClusteringStopCondition.py
Author      : Pablo Boixeda & Ramon Aragues
Creation    : 4.2005
Contents    : Class used to know when clustering should stop
Called from : Clustering.py

=======================================================================================================

This class determines when the clustering process should be halted and clusters at that level returned as answer.

Attention: It has to be overriden by the specific clustering that is being carried out
"""

# ClusteringStopCondition.py: determines when the clustering process should be halted
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

#--------------------------------------------------------------------------------------------
class ClusteringStopCondition(object):
    """
    Class used to know when clustering should stop
    This class determines when the clustering process should be halted and clusters at that level returned as answer.
    
    """

    def __init__(self):
        """
        set here values that will be used to calculate if stop condition is met
        """
        pass


    def condition_is_met(self):
        """
        This method returns true if stop condition is met. False otherwise.

        We use the similarity matrix to calculate if the clustering must stop or not.
        """
        raise RunTimeError("This method must be overridden by a specific clustering condition")

    

    
