"""
File        : TestSimilarityFunction.py
Author      : Pablo Boixeda
Creation    : 5.2005
Contents    : Similarity Function example
Called from : 

=======================================================================================================
"""

# TestSimilarityFunction.py: Similarity Function example
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

from GraphCluster import *
from Clustering import *
from ClusteringSimilarityFunction import *
import numarray

#------------------------------------------------------------------------------------------------
class TestSimilarityFunction(ClusteringSimilarityFunction):
    """
    Similarity Function example
    """

    def calculate_similarity(self, list_node_attributes1, list_node_attributes2):
        """
        Method that returns similarity score from two lists of attributes of nodes that are being clustered

        "list_node_attributes1" is a list of node attributes that belong to the same cluster
        
        "list_node_attributes2" is a list of node attributes that belong to the same cluster

        This method calculates how similar this two clusters are
        """

        # just using one element of the list to calculate the score
        # in more complex clusterings, the element to be used has to be extracted somehow else
        # in fact, we need to implement the different ways of calculating similarities between clusters:
        #    - single linkage (use distances between closest elements)
        #    - average linkage (use average of distances between each element in clusters)
        #    .....

        attribute1 = list_node_attributes1[0]
        attribute2 = list_node_attributes2[0]

        if attribute1.get_proteinPiana()/10000 == attribute2.get_proteinPiana()/10000:
            return 1
        else :
            return 0
