"""
File     : EdgeToPropagate.py
Author   : Ramon Aragues
Creation : 10.2004
Contents : class used to describe an edge that has to be propagated
Comments :

==================================================================================
          used by Graph.expand() to describe edges that have to be propagated

"""
# EdgeToPropagate.py: implements a class for describing an edge that has to be propagated
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

import sys

verbose = 0

class EdgeToPropagate:
    def __init__(self, node_id_edge_comes_from= None, node_id_edge_being_added= None, node_id_new_partner= None,
                 db_edge_id_edge_comes_from= None):
        """
        EdgeToPropagate has the following variables
        """

        self.node_id_edge_comes_from = int(node_id_edge_comes_from)
        self.node_id_edge_being_added = int(node_id_edge_being_added)
        self.node_id_new_partner = int(node_id_new_partner)

        if db_edge_id_edge_comes_from is not None:
            self.db_edge_id_edge_comes_from = int(db_edge_id_edge_comes_from)
        else:
            self.db_edge_id_edge_comes_from = None

    def get_node_id_edge_comes_from(self):
        """
        returns the 
        """
        return self.node_id_edge_comes_from


    def get_node_id_edge_being_added(self):
        """
        returns the 
        """
        return self.node_id_edge_being_added


    def get_node_id_new_partner(self):
        """
        returns the 
        """
        return self.node_id_new_partner


    def get_db_edge_id_edge_comes_from(self):
        """
        returns the 
        """
        return self.db_edge_id_edge_comes_from
