"""
File     : Filters.py
Author   : Daniel Jaeggi and Ramon Aragues
Creation : 2003
Contents : main class providing graph filtering methods
Comments : not being used at the minute

 
 
=======================================================================================================


Skeleton node and edge filter classes for selecting components in a graph.

Edges and nodes in a graph are just abstract containers. Meaning is bestowed
upon them through edge and node attributes. The general method for selecting
a subset of a graph with certain attributes - and, indeed, analysing this
subset - is by defining filters.

A filter can either be a node or and edge filter and must contain a method
called "test" which returns either a 1, if the entity passes the filter, or
a 0 otherwise

"""

# Filters.py: implements a class providing graph filtering methods
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues


from GraphEdge import GraphEdge
from GraphNode import GraphNode


class Filter:
    """
    The base filter class used as a basis for EdgeFilter and NodeFilter.
    """
    pass

class EdgeFilter(Filter):
    """
    The basic edge filter class to be used as a base for custom filters.
    """
    def test(self ,edge):
        """
        This should be overridden. In its current form this will return
        1 if argument "edge" is a GraphEdge object or 0 otherwise.
        """
        if isinstance(edge,GraphEdge):
            return 1
        else:
            return 0

class NodeFilter(Filter):
    """
    The basic node filter class to be used as a base for custom filters.
    """
    def test(self, node):
        """
        This should be overridden. In its current form this will return
        1 if argument "edge" is a GraphNode object or 0 otherwise.
        """
        if isinstance(node,GraphNode):
            return 1
        else:
            return 0
