"""
File        : GraphClusterNodeAttribute.py
Author      : Pablo Boixeda & Ramon Aragues
Creation    : 4.2005
Contents    : Implements the class of an attribute for a GraphNode object in a GraphCluster object
Called from : Programs that implements graph clustering

=======================================================================================================
"""

# GraphClusterNodeAttribute.py: Implements the class of an attribute for a GraphNode object in a GraphCluster object
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

import sys
import getopt
import re
import readline
from sets import *

from Graph import *

class GraphClusterNodeAttribute(GraphNodeAttribute):
    """
    Implements the class of an attribute for a GraphNode object in a GraphCluster object
    """

    def __init__ (self, list_elements=None):
        """
         "list_elements": a list of attributes to set into the new object

        Attention! elements are the original attributes of the GraphNodes we are clustering
        """

        if list_elements is None:
            self.list_attributes=[]
        else:
            self.list_attributes= list_elements

    def get_list_elements(self):
        """
        return list of elements (elements of nodes that we are clustering)
        """
        return self.list_attributes


    def add_element_list(self, list_node_attribute_object= None):
        """
        Adds to this attribute object the elements of  "list_node_attribute_object"
        
        "list_node_attribute_object": A list of GraphNodeAttribute objects that is going to be added to this cluster 
        """
        if list_node_attribute_object is None:
            raise ValueError("Error: No attribute given")
        else:
            self.list_attributes.extend(list_node_attribute_object)
