"""
File        : GraphPatchGroupNodeAttribute.py
Author      : Ramon Aragues
Creation    : 09.2004
Contents    : implementation of GraphPatchGroupNodeAttribute class
Called from : programs/classes that handle a GraphPatchGroupNodeAttribute

=======================================================================================================

This file implements class GraphPatchGroupNodeAttribute

a GraphPatchGroupNodeAttribute represents a group of patches that have been clustered together
because the algorithm decided that they are actually the same type of
patch.

GraphPatchGroupNodeAttribute is the attribute of the nodes in a GraphPatchGroup network
"""

from GraphNodeAttribute import *

verbose = 0

#----------------------------------------------------------------------------------------------
class GraphPatchGroupNodeAttribute(GraphNodeAttribute):
#----------------------------------------------------------------------------------------------
    """
    
    """
    def __init__(self, patch_group_id=None):

        if patch_group_id is None:
            raise ValueError("patch_group_id cannot be None")

        # unique identifier for this PatchGroup
        self.patch_group_id = patch_group_id

        self.dict_patches = {}  # dictionary with keys patch_id and content the patch object

        self.dict_proteinPianas = {} # dictionary with keys proteinPiana and content None

    # -----------------------------------#
    #    modifying methods               #
    # -----------------------------------#

    def add_list_patch_objects(self, new_list_patch_objects):
        """
        add a list of patch objects to this PatchGroup
        """
        new_list_patch_id = []

        for new_patch_object in new_list_patch_objects:

            new_patch_id = new_patch_object.get_patch_id()

            # add the patches 
            if self.dict_patches.has_key(new_patch_id):    
                raise ValueError ("How can I be adding a patch that is already in the PatchGroup? Error?")
            else:
                self.dict_patches[new_patch_id] = new_patch_object

            # add the proteins of the new patches to the proteins of this patchgroup
            new_proteinPiana = new_patch_object.get_proteinPiana()
            if not self.dict_proteinPianas.has_key( new_proteinPiana ):
                self.dict_proteinPianas[new_proteinPiana] = None  # setting to None, since we are only interested in the key

        # END OF for new_patch_object in new_list_patch_objects:


    # -----------------------------------#
    #    get methods                     #
    # -----------------------------------#

    def get_patch_group_id(self):

        return self.patch_group_id


    def get_list_patch(self):
        """
        returns the list of patches that are in this PatchGroup
        
        """
        return self.dict_patches.values()

    def get_list_patch_id(self):
        """
        returns the list of patches that are in this PatchGroup
        
        """
        return self.dict_patches.keys()
    
    def get_list_proteinPiana(self):
        """
        returns the list of proteinPianas of patches in this PatchGroup
        """
        return self.dict_proteinPianas.keys()


    def get_dict_patches(self):
        """
        returns the list of patches that are in this PatchGroup
        
        """
        return self.dict_patches

    
    def get_dict_proteinPianas(self):
        """
        returns the list of proteinPianas of patches in this PatchGroup
        """
        return self.dict_proteinPianas


