"""
File        : ScoringFunction.py
Author      : Ramon Aragues
Creation    : 09.2004
Contents    : implementation of ScoringFunction.py
Called from : user-implemented scoring functions 
Subclass    : 

=======================================================================================================

This file implements class ScoringFunction

ScoringFunction is the general implementation of a scoring
function. All scoring functions used for patch decomposition must be
subclasses of this class.

"""

import sys

#
# TO DO!!! All scoring functions could be written in same module, so they don't have to be imported one by one


#----------------------------------------------------------------------------------------------
class ScoringFunction:
#----------------------------------------------------------------------------------------------
    """
    
    """




    
    def __init__(self, scoring_function_name):
        
        """

        """
        self.name = scoring_function_name

    def get_name(self):
        """
        returns the name of the scoring function: used for keeping record of which scoring function was used for a particular result
        """
        return self.name

    def get_scoring_function(scoring_function_name= None,
                             w_int_patchgroups_shared = None,
                             w_int_proteinPianas_shared = None,
                             w_belong_to_same_protein = None):
        """
        returns a scoring function of the type specified in "scoring_function_name" with weights 
        """
        
        # TO DO!!! Can I have a dictionary of classes so I don't have to go through all the scoring function names and just automatically
        #          call the class that corresponds to a given name (by having a dictionary in PianaGlobals where "quotient":ScoringFunctionQuotient()

        
        if scoring_function_name == "quotient":
            import ScoringFunctionQuotient 
            return ScoringFunctionQuotient.ScoringFunctionQuotient(w_int_patchgroups_shared = w_int_patchgroups_shared,
                                                                   w_int_proteinPianas_shared = w_int_proteinPianas_shared,
                                                                   w_belong_to_same_protein = w_belong_to_same_protein)
        
        elif scoring_function_name == "lineal":
            import ScoringFunctionLineal
            return ScoringFunctionLineal.ScoringFunctionLineal(w_int_patchgroups_shared = w_int_patchgroups_shared,
                                                               w_int_proteinPianas_shared = w_int_proteinPianas_shared,
                                                               w_belong_to_same_protein = w_belong_to_same_protein)
        

    get_scoring_function = staticmethod(get_scoring_function)
        
    def get_scores_array(self, array_interacting_patchgroups_shared, array_interacting_proteinPianas_shared, array_belong_to_same_protein):
        """
        To be overridden by user implemented scoring function

        array_interacting_patchgroups_shared: matrix with number of patchgroups in the overlapping set of interacting patchgroups
        array_interacting_proteinPianas_shared: matrix with number of proteins in the overlapping set of interacting proteinPianas
        array_belong_to_same_protein: matrix with 0 if patchgroups do not contain to same protein, 1 otherwise

        Returns a matrix  with results of applying scoring function

        This array will only be filled for the above-the-diagonal cells... since it is a symmetrical array, that is enough.

        Each cell will contain the score between patchgroup of coordinates [row, column]
        """
        
        raise RunTimeError("This method must be overriden by a user-specific scoring method")
