#!/usr/bin/env python2.2

import sys
sys.path.append("./BioGraph")
from Graph import *
from BioDatabases import *
from BioFilters import *
from Tkinter import *
from tkMessageBox import *
from RouteFinder import *

class MainWindow(Frame):
    def __init__(self, parent=None):
        Frame.__init__(self, parent)
        self.pack()
        self.makeWidgets()

    def makeWidgets(self):
        self.prot_entry = TwoProtEntry(self)
        self.prot_entry.pack(side=TOP)
        # build the database display
        db_list=[]
        string = StringDB()
        dip = DipDB()
        mips = MipsDB()
        bind = BindDB()
        db_list.append(string)
        db_list.append(dip)
        db_list.append(mips)
        db_list.append(bind)
        self.db = DatabaseSelection(db_list,self)
        # build the filter display
        filter_list = []
        #filter_list.append(CogSpeciesFilter("human"))
        #filter_list.append(StringScoreFilter(700))
        filter_list.append(HighConfidenceFilter())
        filter_list.append(MediumConfidenceFilter())
        self.filter = FilterSelection(filter_list,self)
        Quitter(self).pack(side=BOTTOM)
        Button(self, text='Go!', command=self.go_play).pack(side=TOP)
        self.output_box = OutputBox(self)
        self.output_box.pack()
    def go_play(self):
        # the main action subroutine
        rf = RouteFinder()
        dbs = self.db.get_dbs()

        # clear existing databases and add new ones
        rf.clear_databases()
        for db in dbs:
            rf.add_database(db)
        filters = self.filter.get_filters()
        for filter in filters:
            rf.add_filter(filter)

        self.prots = self.prot_entry.get_proteins()
        if not self.prots[0]:
            showwarning("Ok","No input given for protein 1")
        if not self.prots[1]:
            showwarning("Ok","No input given for protein 2")
        rf.set_start_protein(self.prots[0])
        rf.set_target_protein(self.prots[1])
        self.output_box.display_output(rf.find_routes())
        #print rf.output_graph()
        
class Quitter(Frame):
    def __init__(self, parent=None):
        Frame.__init__(self, parent)
        self.pack()
        self.makeWidgets()
    def makeWidgets(self):
        Button(self, text='Quit', command=self.confirm_quit).pack()
    def confirm_quit(self):
        if askyesno('Verify', 'Do you really want to quit?'):
            self.quit()

class TwoProtEntry(Frame):
    def __init__(self, parent=None):
        Frame.__init__(self, parent)
        self.pack()
        self.makeWidgets()
        self.prot1 = None
        self.prot2 = None
    def makeWidgets(self):
        self.p1 = ProtEntry(self)
        self.p1.pack(side=LEFT)
        self.p2 = ProtEntry(self)
        self.p2.pack(side=RIGHT)
        self.p1.ent.focus()
        
    def get_proteins(self):
        return (self.p1.get_prot(), self.p2.get_prot())

class ProtEntry(Frame):
    def __init__(self, parent=None):
        Frame.__init__(self, parent)
        self.protein = None
        self.display_prot = StringVar()
        self.pack()
        self.makeWidgets()
        #self.update_text()
    def makeWidgets(self):
        self.msg = Label(self,text="Enter protein:")
        self.msg.config(font=('times', 12))
        self.msg.pack()
        self.stat = Label(self,textvariable=self.display_prot)
        self.stat.pack()
        self.ent = Entry(self)
        self.ent.pack(fill=X)
        #self.ent.focus()
        # self.ent.bind('<Return>', (lambda event: self.set_prot()))
    def set_prot(self):
        self.protein = self.ent.get()
        self.display_prot.set(self.protein)
    def get_prot(self):
        self.set_prot()
        return self.protein

class DatabaseSelection(Frame):
    def __init__(self, db_list, parent=None):
        Frame.__init__(self, parent)
        self.db_list = db_list
        self.pack()
        self.makeWidgets()
    def makeWidgets(self):
        Label(self,text="Available Databases:").pack(side=TOP)
        self.vars = []
        for db in self.db_list:
            var = IntVar()
            Checkbutton(self, text=db,  variable=var).pack(side=LEFT)
            self.vars.append(var)
    def get_dbs(self):
        selected_dbs = []
        i = 0
        for var in self.vars:
            if var.get():
                selected_dbs.append(self.db_list[i])
            i = i + 1
        return selected_dbs

class FilterSelection(Frame):
    def __init__(self, filter_list, parent=None):
        Frame.__init__(self, parent)
        self.filter_list = filter_list
        self.pack()
        self.makeWidgets()
    def makeWidgets(self):
        Label(self, text="Available Filters:").pack(side=TOP)
        self.vars = []
        for filter in self.filter_list:
            var = IntVar()
            Checkbutton(self, text=filter, variable=var).pack(side=LEFT)
            self.vars.append(var)
    def get_filters(self):
        selected_filters = []
        i = 0
        for var in self.vars:
            if var.get():
                selected_filters.append(self.filter_list[i])
            i = i + 1
        return selected_filters
    
class OutputBox(Frame):
    def __init__(self, parent=None):
        Frame.__init__(self,parent)
        self.display_output_text = StringVar()
        self.pack()
        self.makeWidgets()
    def makeWidgets(self):
        self.box_label = Label(self,text="Output from routefinding program:")
        self.box_label.pack()
        self.display = Label(self,textvariable=self.display_output_text)
        self.display.pack()
    def display_output(self,text):
        self.display_output_text.set(text)
                
                
if __name__ == '__main__':
    root = Tk()
    root.title("Protein Interaction Tool")
    MainWindow(root).pack()
    root.mainloop()
