"""
File        : parseDIP.py
Author      : Ramon Aragues
Creation    : 13.11.2003
Contents    : DIP parser: uses DipContentHandler to parse DIP xml files

=======================================================================================================

Implements a DIP parser: it reads the XML file and either: - inserts information into dip mysql db (as described in create_dip_db.sql)
                                                              or
                                                           - prints out information to stdout


"""
import MySQLdb
import getopt
import sys

from DipContentHandler import *


# ----------------------
# Function usage()
# ----------------------
def usage():
    print "\nUsage: parseDIP.py --dip-dbname=dip_dbname --dip-dbhost=dip_dbhost --dip-dbuser=dip_dbuser --dip-dbpass=dip_dbpass"
    print "                   --input-file=input_file  --mode=output_mode [--help] [--verbose]"
    print "  Where:"
    print "        input_file     : name of the file that contains DIP info on protein interactions (dip xml file (.xin))"
    print "        dip_dbhost     : name of the machine with dip mysql server (required)"
    print "        dip_dbuser     : name of the mysql dip username (not required in most systems)"
    print "        dip_dbpass     : name of the mysql dip username (not required in most systems)"
    print "        output_mode    : output mode desired (dipDB or text)"
    print "                          - mode 'dipDB' inserts content into mysql dip database"
    print "                          - mode 'text' prints output to stdout"
    print "        --help         : prints this message"
    print "        --verbose      : prints process info"
    print "--------------------------------------------------------------------------------------------------------------"
    print "Attention! DIP data sets might be corrupted: read piana/data/externalDBs/dipDB/README.error_parsing_explanation"
    print "--------------------------------------------------------------------------------------------------------------"
    

# ---------------------------
# Function parseArguments()                                               
# --------------------------- 

def parseArguments():
    
    global dip_dbname  
    global dip_dbhost
    global dip_dbuser
    global dip_dbpass
    
    global input_file
    global output_mode
    
    global verbose

    
    try:
        opts,args = getopt.getopt(sys.argv[1:],"",["verbose", "help", "input-file=","mode=",
                                                   "dip-dbname=","dip-dbuser=","dip-dbhost=","dip-dbpass="])
    except getopt.GetoptError, bad_opt:
        # print help information and exit:
        sys.stderr.write( bad_opt.__str__() )
        usage()
        sys.exit(2)
     
    for option,value in opts:
         if option == "--input-file":
             input_file = value
               
         elif option == "--mode":
             output_mode = value
               
         elif option == "--verbose":
             verbose = 1

         elif option == "--dip-dbhost":
             dip_dbhost = value
             
         elif option == "--dip-dbname":
             dip_dbname = value
             
         elif option == "--dip-dbuser":
             dip_dbuser = value
             
         elif option == "--dip-dbpass":
             dip_dbpass = value
             
         elif option ==  "--help":
             # print help information and exit
             usage()
             sys.exit(2)
              
    if input_file is None:
        print "--------------------------------"
        print "parseDIP.py arguments error: You didn't set a valid input file"
        print "--------------------------------"
        usage()
        sys.exit(2)    
        
    if output_mode != "dipDB" and output_mode != "text":
        print "--------------------------------"
        print "parseDIP.py arguments error: You didnt set a valid output mode (dipDB or text)"
        print "--------------------------------"
        usage()
        sys.exit(2)

        
# ---------------------
# method parse_dip_file
# ---------------------


def parse_dip_file(input_file, output_mode, verbose, dip_dbhost, dip_dbname, dip_dbuser, dip_dbpass):
    
    handler = DipContentHandler(output_mode=output_mode , verbose=verbose,
                                dip_dbhost=dip_dbhost, dip_dbname=dip_dbname, dip_dbuser=dip_dbuser, dip_dbpass=dip_dbpass)
    parser = make_parser()
    parser.setContentHandler(handler)
    
    try:
        parser.parse(open(input_file))
    except SAXException:
        return handler.mobile
    return None

# --------
# --------
#  Main()               
# --------                               
# --------

if __name__ == '__main__':

    

    dip_dbname = None
    dip_dbuser = None
    dip_dbhost = None
    dip_dbpass = None

    input_file = None
    output_mode = None

    
    # parsing arguments from the command line
    parseArguments()

    # calling function that will parse the input_file with mode output_mode 
    dip_parsed = parse_dip_file(input_file=input_file, verbose=verbose, output_mode=output_mode,
                                dip_dbhost=dip_dbhost, dip_dbname=dip_dbname, dip_dbuser=dip_dbuser, dip_dbpass= dip_dbpass)

    
