"""
File        : insertInteraction.py
Author      : Ramon Aragues
Creation    : 08.07.2004
Contents    : script that inserts an interaction into pianaDB
Called from : 

=======================================================================================================

This program inserts an interaction (hardcoded here below) into pianaDB

To insert interactions from a text file, use instead
piana/code/dbParsers/piana_text_intParser/piana_text_int2pianaDB.py

Command line option '--help' describes usage of this program

"""

# insertInteraction.py: script that inserts an interaction into pianaDB
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

import sys
import getopt

import re
import readline

import MySQLdb

from PianaDBaccess import *



verbose = 1

# ---------------------------------------------------------------
# Set here the default values for command line arguments
# ---------------------------------------------------------------
#
# These will be the values taken by the program when called directly from build_database.py

# write here pairs of interactions that you want to insert
# This list must follow the format:
#
# Attention! do not use geneNames, or if you do, set the tax_id
#            in get_list_protein_piana

# p48 interactions with RBPJK

"""
list_of_interactions = [ ["uniacc", "Q64305", "P28159", "p48DB", "p48Method"],
                         ["uniacc", "Q64305", "O02019", "p48DB", "p48Method"],
                         ["uniacc", "Q64305", "Q06330", "p48DB", "p48Method"],
                         ["uniacc", "Q9QX98", "P28159", "p48DB", "p48Method"],
                         ["uniacc", "Q9QX98", "O02019", "p48DB", "p48Method"],
                         ["uniacc", "Q9QX98", "Q06330", "p48DB", "p48Method"],
                         ["uniacc", "Q9QYF5", "P28159", "p48DB", "p48Method"],
                         ["uniacc", "Q9QYF5", "O02019", "p48DB", "p48Method"],
                         ["uniacc", "Q9QYF5", "Q06330", "p48DB", "p48Method"],
                         ["uniacc", "Q7RTS3", "P28159", "p48DB", "p48Method"],
                         ["uniacc", "Q7RTS3", "O02019", "p48DB", "p48Method"],
                         ["uniacc", "Q7RTS3", "Q06330", "p48DB", "p48Method"],
                         ["uniacc", "Q7ZSX3", "P28159", "p48DB", "p48Method"],
                         ["uniacc", "Q7ZSX3", "O02019", "p48DB", "p48Method"],
                         ["uniacc", "Q7ZSX3", "Q06330", "p48DB", "p48Method"]
                       ]

"""

list_of_interactions = [ ["unientry", "PSA1_YEAST", "MOT1_YEAST", "string", "y2h"],
                         ["unientry", "PSA1_YEAST", "MOT1_RAT",   "string", "calcium"],
                         ["unientry", "PSA1_YEAST", "MOT1_HUMAN", "ori", "y2h"]
                       ]

# ----------------------
# Function usage()
# ----------------------
def usage():
    print "--------------------------------------------------------------------------------------------------------------"
    print "This program fills up tables in database piana related to external DB 'expansion' \n"
    print "Usage: python insertInteraction.py --piana-dbname=piana_dbname --piana-dbhost=piana_dbhost "
    print "                                 --piana-dbuser=piana_dbuser --piana-dbpass=piana_dbpass [--help] [--verbose]"
    print "\nwhere:"
    print "     piana_dbname : name of database piana to be used (required)"
    print "     piana_dbhost : name of host where database piana to be used is placed (required)"
    print "     piana_dbuser : username accessing the database (not required in most systems)"
    print "     piana_dbpass : password of username accessing the database (not required in most systems)"
    print "     --help         : prints this message and exits"
    print "     --verbose      : prints process info to stdout"
    print "--------------------------------------------------------------------------------------------------------------"

# ---------------------------
# Function parseArguments()                                               
# --------------------------- 

def parseArguments():
    
    global piana_dbname
    global piana_dbhost
    global piana_dbuser
    global piana_dbpass
    
    global verbose
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "vhn:o:u:w:", ["verbose","help",
                                                              "piana-dbname=", "piana-dbhost=", "piana-dbuser=", "piana-dbpass="])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
     
    for option,value in opts:

        if option in ("-n", "--piana-dbname"):
            piana_dbname = value
            
        elif option in ("-o", "--piana-dbhost"):
            piana_dbhost = value
            
        elif option in ("-u", "--piana-dbuser"):
            piana_dbuser = value
             
        elif option in ("-w", "--piana-dbpass"):
            piana_dbpass = value
            
        elif option in ("-v", "--verbose"):
            verbose = 1
            
        elif option in ("-h", "--help"):
            # print help information and exit
            usage()
            sys.exit(2)
             
    # END OF for option,value in opts:
        
  # ---------------------------
# Function standardize protein type()                                               
# --------------------------- 

def standardize_protein_type(code_type=None):
    """
    returns [proteins_type, proteins_table] related to code_type
    this is necessary to guarantee communication with the database tables]
    """


    # TO CHECK!!! I think I don't use input_proteins_table... but I do use output_proteins_table
    
    while 1:
        # Standardize the protein code type to piana code types
        if code_type == "uniacc":
            return [PianaGlobals.swissAccessionID_col, PianaGlobals.swissAccession_table]

        elif code_type == "unientry":
            return [PianaGlobals.swissProtID_col, PianaGlobals.swissProt_table]

        elif code_type == "proteinPiana":
            return [PianaGlobals.proteinPiana_col, PianaGlobals.protein_table]

        elif code_type == "geneName":
            return [PianaGlobals.geneName_col, PianaGlobals.geneName_table]
        else:

            raise ValueError("incorrect type set for protein")
    # END OF while 1:
    
# --------
# --------
#  Main()               
# --------                               
# --------
piana_dbname = None
piana_dbuser = None
piana_dbhost = None
piana_dbpass = None

input_proteins_type = None
input_proteins_table = None


# parsing arguments from the command line
parseArguments()

# Initialisating connection to piana
piana_access = PianaDBaccess(dbname=piana_dbname, dbhost=piana_dbhost, dbuser=piana_dbuser, dbpassword= piana_dbpass)

#
# Inserting interactions
# 

number_of_interactions_added = 0
number_of_interactions_no_id = 0

for interaction in list_of_interactions:
    # interaction is:
    # 0 - type of code of proteins in this interaction
    # 1 - proteinA
    # 2 - proteinB
    # 3 - source database
    # 4 - method

        
        [std_input_proteins_type, std_input_proteins_table] = standardize_protein_type(code_type= interaction[0])

        
        list_protein_piana_a = piana_access.get_list_protein_piana(proteinCode_value= interaction[1],
                                                                   proteinCodeType_value= std_input_proteins_type,
                                                                   tax_id_value = 0, source_db_info= "yes")
        
        list_protein_piana_b = piana_access.get_list_protein_piana(proteinCode_value= interaction[2],
                                                                   proteinCodeType_value= std_input_proteins_type,
                                                                   tax_id_value = 0, source_db_info= "yes")
        
        for proteinPiana_a in list_protein_piana_a:
            for proteinPiana_b in list_protein_piana_b:
                # proteinPiana_a is a pair (proteinPiana, source_db)
                # proteinPiana_b is a pair (proteinPiana, source_db)

                if verbose:
                    sys.stderr.write("calling insert_interaction with proteinA %s, proteinB %s, method %s and db %s\n" %(proteinPiana_a,
                                                                                                                         proteinPiana_b,
                                                                                                                         interaction[4],
                                                                                                                          interaction[3]))
                if proteinPiana_a[1] == "completion" or proteinPiana_b[1] == "completion":
                    piana_access.insert_interaction(proteinPianaA_value = proteinPiana_a[0],
                                                    isSourceA_value = 1,
                                                    proteinPianaB_value = proteinPiana_b[0],
                                                    isSourceB_value = 1,
                                                    interactionConfidence_value = 1,
                                                    methodDescription_value = interaction[4],
                                                    sourceDBDescription_value =  interaction[3] + "_c",
                                                    confidenceAssignedSourceDB_value=1)
                else:
                    piana_access.insert_interaction(proteinPianaA_value = proteinPiana_a[0],
                                                    isSourceA_value = 1,
                                                    proteinPianaB_value = proteinPiana_b[0],
                                                    isSourceB_value = 1,
                                                    interactionConfidence_value = 1,
                                                    methodDescription_value = interaction[4],
                                                    sourceDBDescription_value =  interaction[3],
                                                    confidenceAssignedSourceDB_value=1)
                    
                number_of_interactions_added += 1
            # END OF for proteinPiana_b in list_protein_piana_b:
        # END OF for proteinPiana_a in list_protein_piana_a:
        
        if verbose:
            if not list_protein_piana_a or not list_protein_piana_b:
                
                sys.stderr.write("proteinPiana not found for %s or %s \n" %(interaction[1], interaction[2]))
                number_of_interactions_no_id += 1
        
if verbose:
    sys.stderr.write("All done! Number of interactions added: %s . Number of interactions without proteinPiana: %s\n\n" %(number_of_interactions_added,
                                                                                                                          number_of_interactions_no_id))
