
import sys
import getopt

import re
import readline

from sets import *

import MySQLdb

from PianaDBaccess import *
from PianaGraphBuilder import *

from PianaGraph import *

from Clustering import *

from GoClusteringSimilarityFunction import *

from GoClusteringStopCondition import *

from GraphCluster import *

from GoGraph import *


verbose = 1


# ----------------------
# Function usage()
# ----------------------
def usage():
    print "--------------------------------------------------------------------------------------------------------------"
    print "Usage: python test_something_piana.py --input-file --input-proteins-type"
    print "                          --piana-dbname=piana_dbname --piana-dbhost=piana_dbhost --piana-dbuser=piana_dbuser --piana-dbpass=piana_dbpass"
    print "                                 [--help] [--verbose]"
    print "\nwhere:"
    print "     input_file   : file with query proteins"
    print "     input_proteins_type  : type of protein code used in input_file "
    print "     piana_dbname : name of database piana to be used (required)"
    print "     piana_dbhost : name of host where database piana to be used is placed (required)"
    print "     piana_dbuser : username accessing the database (not required in most systems)"
    print "     piana_dbpass : password of username accessing the database (not required in most systems)"
    print "     --help         : prints this message and exits"
    print "     --verbose      : prints process info to stdout"
    print "--------------------------------------------------------------------------------------------------------------"
        

   
# ---------------------------
# Function parseArguments()                                               
# --------------------------- 

def parseArguments():
    
    global piana_dbname
    global piana_dbhost
    global piana_dbuser
    global piana_dbpass
    
    global input_file
    global input_proteins_type
    
    
    global verbose
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "vht:c:n:o:u:w:", ["verbose","help","input-file=", "input-proteins-type=",
                                                                   "piana-dbname=", "piana-dbhost=", "piana-dbuser=", "piana-dbpass=" ])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
     
    for option,value in opts:
        
         if option in ("-t", "--taxonomy-file"):
             taxonomy_file = value
            
         elif option in ("-n", "--piana-dbname"):
             piana_dbname = value
             
         elif option in ("-o", "--piana-dbhost"):
             piana_dbhost = value
            
         elif option in ("-u", "--piana-dbuser"):
             piana_dbuser = value
             
         elif option in ("-w", "--piana-dbpass"):
             piana_dbpass = value
             
         elif option in ("-w", "--input-file"):
             input_file = value
             
         elif option in ("-w", "--input-proteins-type"):
             input_proteins_type = value
             
         elif option in ("-v", "--verbose"):
             verbose = 1
         elif option in ("-h", "--help"):
             # print help information and exit
             usage()
             sys.exit(2)
    # END OF for option,value in opts:
    
    if input_file is None:
        raise ValueError("input_file cannot be None")

    if input_proteins_type is None:
        raise ValueError("input_protein_type cannot be None")
       
# --------
# --------
#  Main()               
# --------                               
# --------

input_file = None
input_proteins_type = None

piana_dbname = None
piana_dbuser = None
piana_dbhost = None
piana_dbpass = None

# parsing arguments from the command line
parseArguments()

# Initialisating connection to piana
piana_access = PianaDBaccess(dbname=piana_dbname, dbhost=piana_dbhost, dbuser=piana_dbuser, dbpassword= piana_dbpass)


"""
comparing ste20 exp ints with predicted ints
"""

piana_graph = PianaGraph("clustering level 1", piana_access_object= piana_access)

query_proteins = []

for line in file(input_file,  "r"):
    query_proteins.append( line.strip() )

piana_builder = PianaGraphBuilder(piana_access_object=piana_access,
                                  depth= 1,
                                  hub_threshold= 0,
                                  list_protein_codes = query_proteins,
                                  code_type_name= input_proteins_type )

sys.stderr.write("Building interaction network\n")

piana_graph.build_graph(piana_builder)

source_network_file_name = "toto.source_network"

sys.stderr.write("Printing interaction network to %s\n" %source_network_file_name)

piana_graph.output_interactions(protein_type_name="proteinPiana",
                                output_target=file(source_network_file_name, "w"),
                                output_format="dot")


sys.stderr.write("Creating GoGraph Object \n")

go_graph=GoGraph(piana_access_object = piana_access, term_type_value = "molecular_function")

sys.stderr.write("Initializing GoGraph from a pianaGraph\n")

go_graph=go_graph.initialize_GoGraph_from_pianaGraph(pianaGraph = piana_graph)

result_network_file_name="toto.result_network"
go_graph.print_go_dot_file(output_target=file(result_network_file_name, "w"))
