"""
File        : Patch.py
Author      : Ramon Aragues
Creation    : 09.2004
Contents    : implementation of Patch class
Called from : programs/classes that handle a Patch

=======================================================================================================

This file implements class Patch


Patch represents a region of the protein that is interacting with another protein (i.e. the interface)


"""

verbose = 0

#----------------------------------------------------------------------------------------------
class Patch:
#----------------------------------------------------------------------------------------------
    """
    
    """
    def __init__(self, patch_id=None, proteinPiana= None):
        """
        patch_id is the unique identifier for the initial patch
        proteinPiana is the protein that has this patch
        """

        if patch_id is None or proteinPiana is None:
            raise ValueError("Patch initialisation expects values for patch_id and proteinPiana")

        # unique identifier for this patch
        self.patch_id = patch_id

        # indicates to which protein this patch belongs to
        self.proteinPiana = proteinPiana


        
    # ------------------------------------------
    #  Patch Methods
    #------------------------------------------

    def get_patch_id(self):

        return self.patch_id

    def get_proteinPiana(self):

        return self.proteinPiana

