"""
 File       : PianaGraphEdgeTypes.py
 Author     : R. Aragues
 Creation   : 2003
 Contents   : classes PianaGraphEdgeTypes
 Called from: 

=======================================================================================================

This file implements classes  ExtendedEdge and  PropagatedEdge

classes used to describe characteristics of edges that have been extended or propagated by
an expansion process

"""

# PianaGraphEdgeTypes.py: implements a classes ExtendedEdge and  PropagatedEdge
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues


verbose = 0

class ExtendedEdge:
    """
    This class is used to describe the expansion_extension that originated an edge. It is used by PianaGraphEdgeAttribute to keep a list
    of characteristics of a given edge
    
    """
    def __init__(self, expansion_type= None, extended_from_node= None):
        self.expansion_type = expansion_type
        self.extended_from_node = extended_from_node

    def __str__(self):
        return "expansion type %s extends from node %s" %(self.expansion_type, self.extended_from_node)

    def get_source_node(self):
        """
        returns the node that originated the extension of the edge
        """
        return self.extended_from_node
            
class PropagatedEdge:
    """
    This class is used to describe the expansion_propagation that originated an edge. It is used by PianaGraphEdgeAttribute to keep a list
    of characteristics of a given edge

    These two variables identify the origin of the new edge:
        propagated_from_db_edge_id is an interactionPiana identifier
        propagated_from_edge_id is the internal graph edge identifier (composed by the two node identifiers)
    
    """
    def __init__(self, expansion_type= None, propagated_from_node= None, propagated_from_edge_id= None, propagated_from_db_edge_id= None):
        self.expansion_type = expansion_type
        self.propagated_from_node = propagated_from_node
        self.propagated_from_db_edge_id = propagated_from_db_edge_id
        self.propagated_from_edge_id = propagated_from_edge_id

    def __str__(self):
        return "expansion type %s propagates interaction %s (edge internal id= %s) from node %s" %(self.expansion_type,
                                                                                                   self.propagated_from_db_edge_id,
                                                                                                   self.propagated_from_edge_id,
                                                                                                   self.propagated_from_node)
    def get_source_node_id(self):
        """
        returns the node id that originated the propagation of this edge
        """
        return self.propagated_from_node


    def get_source_edge_db_id(self):
        """
        returns the database edge id (interactionPiana) that originated the propagation of this edge
        """
        return self.propagated_from_db_edge_id


    def get_source_edge_db_id(self):
        """
        returns the graph edge id  that originated the propagation of this edge
        """
        return self.propagated_from_edge_id

