"""
File        : get_interactions_from_dipDB.py
Author      : Ramon Aragues
Creation    : 16.12.2003
Contents    : 
Called from : 

=======================================================================================================

This program lists dip interactions for a given case, that has to be hardcoded in the sql statement below

a DIP database must exist already with format shown in create_dip_tables.sql (directory code/dbCreation)

This existing DIP database was previously filled by another program (e.g. parseDIP.py)


Sample Usage:
------------

"""
import sys
import getopt

import re
import readline
import MySQLdb

from PianaDB import *

verbose = 1



# ----------------------
# Function usage()
# ----------------------
def usage():
    print "--------------------------------------------------------------------------------------------------------------"
    print "This program fills up tables in database piana with information from DIP \n"
    print "Usage: python update_database.py --dip-db-name=dip_db_name "
    print "                                 --mysql-server=server --mysql-username=username  [--help] [--verbose]"
    print "\nwhere:"
    print "     dip_dbname   : name of the dip mysql database (required)"
    print "     dip_dbhost   : name of the machine with dip mysql server (required)"
    print "     dip_dbuser   : name of the mysql dip username (not required in most systems)"
    print "     dip_dbpass   : name of the mysql dip username (not required in most systems)"
    print "     --help         : prints this message and exits"
    print "     --verbose      : prints process info to stdout"
    print "--------------------------------------------------------------------------------------------------------------"
        

   
# ---------------------------
# Function parseArguments()                                               
# --------------------------- 

def parseArguments():
    
    global dip_dbname  
    global dip_dbhost
    global dip_dbuser
    global dip_dbpass
    
    global verbose
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "vha:z:x:y:", ["verbose","help","dip-dbname=","dip-dbuser=","dip-dbhost=","dip-dbpass=",])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
     
    for option,value in opts:
        
        if option in ("-a", "--dip-dbhost"):
            dip_dbhost = value
            
        elif option in ("-z", "--dip-dbname"):
            dip_dbname = value
            
        elif option in ("-y", "--dip-dbuser"):
            dip_dbuser = value
            
        elif option in ("-x", "--dip-dbpass"):
            dip_dbpass = value
            
        elif option in ("-v", "--verbose"):
            verbose = 1
        elif option in ("-h", "--help"):
            # print help information and exit
            usage()
            sys.exit(2)
        
# --------
# --------
#  Main()               
# --------                               
# --------

dip_dbname = None
dip_dbuser = None
dip_dbhost = None
dip_dbpass = None

# parsing arguments from the command line
parseArguments()

if dip_dbname is None or dip_dbhost is None:
    raise ValueError("trying to establish a connection to dip database without giving a host or database name")

# opening connection to MySQL DIP database and create a cursor to work with the database
if dip_dbuser is None and dip_dbpass is None:
    dipdb = MySQLdb.connect(db=dip_dbname, host=dip_dbhost)
                
elif dip_dbpass is None and dip_dbuser is not None:
    dipdb = MySQLdb.connect(user=dip_dbuser, db=dip_dbname, host=dip_dbhost)
    
else:
    dipdb = MySQLdb.connect(user=dip_dbuser, db=dip_dbname, host=dip_dbhost, passwd= dip_dbpass )



dipcursor = dipdb.cursor()


sqlquery = """select n1.node_uid, n2.node_uid from edges, nodes n1, nodes n2 where n1.node_id=edge_from and n2.node_id=edge_to;"""
dipcursor.execute(sqlquery)
dip_interactions = dipcursor.fetchall()

for dip_interaction in dip_interactions:

    print "%s\t%s" %(dip_interaction[0], dip_interaction[1])
