""" 
File : parseGo.py 
Author : Pablo Boixeda 
Creation : 6.02.2005 
Contents : GO parser: Dumps GO Database (http://www.godatabase.org/dev) into a MySql database 
======================================================================================================= 
This file Dumps GO Database (http://www.godatabase.org/dev) into a MySql database

The database must be created before running this parser: mysql> create database go_dbname

read README.parsing_go for more information on how to parse go


"""

# parseGo.py: GO parser: Dumps GO Database (http://www.godatabase.org/dev) into a MySql database 
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues


import os
import MySQLdb 
import getopt

import utilities


verbose = 0
""" 
--------------------- 
function usage() 
--------------------- 
prints out help on how to use the program 
""" 
def usage(): 
   print "--------------------------------------------------------------------------------------------------------------"
   print "This program fills up tables in database go_dbname with information from GO files \n"
   print "Usage: parseGO.py  --input-go-dir=go_directory --go-dbname=go_dbname --go-dbhost=go_dbhost --go-dbuser=go_dbuser --go-dbpass=go_dbpass" 
   print "\n where:" 
   print "         go_dbname: name of the GO mysql database " 
   print "         go_dbhost: name of the machine with mysql server "
   print "         go_dbuser : name of the mysql username (not required in most systems)" 
   print "         go_dbpass : your MySql password for your account (not required in most systems)"
   print "         go_directory: complete path of the directory that contains go data files"
   print "         --help       : prints this message and exits"
   print "         --verbose    : prints process info to stdout"
   print "--------------------------------------------------------------------------------------------------------------"

""" 
--------------------- 
function parseArguments() 
--------------------- 
parses arguments from the command line and sets variables accordingly 
""" 

def parseArguments(): 

	global go_dbhost 
	global go_dbuser
	global go_dbpass
	global go_dbname 
	global go_input_dir

	try: 
		opts,args = getopt.getopt(sys.argv[1:],"",["help","go-dbhost=","go-dbuser=","go-dbpass=","go-dbname=","input-go-dir="])
		
	except getopt.GetoptError, error: 
		# print help information and exit: 
		sys.stderr.write( "Unrecognized flag or option: %s\n" %(error) )
		usage() 
		sys.exit(2) 

	for option,value in opts: 
           if option == "--go-dbhost": 
              go_dbhost = value 
           elif option  == "--go-dbuser": 
              go_dbuser = value 
           elif option  == "--go-dbname": 
              go_dbname = value
           elif option  == "--go-dbpass":
              go_dbpass= value
           elif option  == "--input-go-dir":
              go_input_dir=value
           elif option ==  "--verbose":
              verbose = 1
           elif option ==  "--help": 
              # print help information and exit 
              usage() 
              sys.exit(2)
	# END OF for option,value in opts: 



	if (go_dbhost is None or go_dbname is None): 
		print "--------------------------------" 
		print "parseGO.py arguments error: You didnt set database information needed " 
		print "--------------------------------" 
		usage() 
		sys.exit(2) 
		



""" 
--------------------- 
method parse_go 
--------------------- 
""" 
def parse_go(go_dbhost, go_dbuser, go_dbpass, go_dbname, dir): 

	# opening connection to MySQL database and create a cursor to work with the database 

	
	files_to_exec= utilities.GlobDirectoryWalker(dir,"*.sql")
	
	for file_name in files_to_exec:

		table_name = file_name.split("/")[-1][:-4]
		
		if go_dbuser is None:
			drop_table_sql = """mysql -D %s -h %s -e "drop table %s" """ %(go_dbname, go_dbhost, table_name )
			create_table_sql = """mysql -D %s -h %s < %s""" %(go_dbname, go_dbhost, file_name)
			load_table_sql = """mysql -D %s -h %s -e "load data local infile '%s' replace into table %s" """ %(go_dbname, go_dbhost,
															    file_name[:-3]+ "txt",
															    table_name)


			if verbose:
				sys.stderr.write("Executing command: %s\n" %(drop_table_sql))
				sys.stderr.write("Executing command: %s\n" %(create_table_sql))
				sys.stderr.write("Executing command: %s\n\n" %(load_table_sql))
			
			os.system(drop_table_sql)
			os.system(create_table_sql)	
			os.system(load_table_sql)
		else:
			sys.stderr.write ("No user name and password allowed\n")
		

""" 
--------------------- 
Main 
--------------------- 
""" 
if __name__ == '__main__': 

	import sys 
	# global variables 
	go_dbhost = None 
	go_dbuser = None
	go_dbpass =None
	go_dbname = None
	go_input_dir=None

	# parsing arguments from the command line 
	parseArguments()
	
	# calling function that will parse the input directory
	parse_go(go_dbhost, go_dbuser,go_dbpass, go_dbname, go_input_dir ) 


