"""
File        : piana_translation_file2one_translated_code_per_line.py
Author      : Ramon Aragues
Creation    : 11.01.2005
Contents    : script that translates a piana *.id_type2id_type file to a file with one translated code
              per line
Called from : 

=======================================================================================================

This script creates a fasta file from a set of input proteins


Command line option '--help' describes usage of this program


"""

# piana_translation_file2one_translated_code_per_line.py:
# script that translates a piana *.id_type2id_type file to
# a file with one translated code per line
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

import sys
import getopt

import re
import readline

verbose = 1

# ---------------------------------------------------------------
# Set here the default values for command line arguments
# ---------------------------------------------------------------
#
# These will be the values taken by the program when called directly from build_database.py

# ----------------------
# Function usage()
# ----------------------
def usage():
    print "--------------------------------------------------------------------------------------------------------------"
    print "This script translates a piana *.id_type2id_type file to a file with one translated code per line\n"
    print "Usage: python piana_translation_file2one_translated_code_per_line.py  "
    print "                 --input-file=input_file --output-file=output_file [--help] [--verbose]"
    print "\nwhere:"
    print "     input_file     : file with protein names to be retrieved"
    print "     output_file    : file where output file will be saved"
    print "     --help         : prints this message and exits"
    print "     --verbose      : prints process info to stdout"
    print "--------------------------------------------------------------------------------------------------------------"
        

# ---------------------------
# Function parseArguments()                                               
# --------------------------- 

def parseArguments():
    
    
    global input_file
    global output_file
    
    global verbose
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "", ["verbose","help","input-file=","output-file="])
    except getopt.GetoptError, msg:
        # print help information and exit:
        sys.stderr.write( "\n\n--\ncommand line arguments are not correct: %s\n--\n\n" %(msg))
        # print help information and exit:
        usage()
        sys.exit(2)
     
    for option,value in opts:
        
        if option == "--input-file":
            input_file = value
            
        elif option == "--output-file":
            output_file = value
            
        elif option == "--verbose":
            verbose = 1
            
        elif option == "--help":
            # print help information and exit
            usage()
            sys.exit(2)
            
    # END OF for option,value in opts:
    
    if input_file is None:
        sys.stderr.write("You didn't set an input file\n")
        usage()
        sys.exit(2)
        
    if output_file is None:
        sys.stderr.write("You didn't set an output file\n")
        usage()
        sys.exit(2)
        
# --------
# --------
#  Main()               
# --------                               
# --------

input_file = None
output_file = None

# parsing arguments from the command line
parseArguments()

if verbose:
    sys.stderr.write( "Transforming file...\n")


input_fd = file(input_file,"r")

output_fd = file(output_file,"w")

for line in input_fd:

    list_codes = line.split()

    # list_codes is a list where the first element is the original code and the following its translations
    # we want to print to output_file all the translations, one per line

    for code in list_codes[1:]:
        output_fd.write("%s\n" %(code))
        
# END OF for line in input_fd
    
input_fd.close()
output_fd.close()
