
import sys
import getopt

import re
import readline

from sets import *

import MySQLdb

from PianaDBaccess import *
from PianaGraphBuilder import *

from PianaGraph import *

from Clustering import *

from TestSimilarityFunction import *

from TestStopCondition import *

from GraphCluster import *


verbose = 1


# ----------------------
# Function usage()
# ----------------------
def usage():
    print "--------------------------------------------------------------------------------------------------------------"
    print "Usage: python test_something_piana.py "
    print "                          --piana-dbname=piana_dbname --piana-dbhost=piana_dbhost --piana-dbuser=piana_dbuser --piana-dbpass=piana_dbpass"
    print "                                 [--help] [--verbose]"
    print "\nwhere:"
    print "     piana_dbname : name of database piana to be used (required)"
    print "     piana_dbhost : name of host where database piana to be used is placed (required)"
    print "     piana_dbuser : username accessing the database (not required in most systems)"
    print "     piana_dbpass : password of username accessing the database (not required in most systems)"
    print "     --help         : prints this message and exits"
    print "     --verbose      : prints process info to stdout"
    print "--------------------------------------------------------------------------------------------------------------"
        

   
# ---------------------------
# Function parseArguments()                                               
# --------------------------- 

def parseArguments():
    
    global piana_dbname
    global piana_dbhost
    global piana_dbuser
    global piana_dbpass
    
    
    global verbose
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "vht:c:n:o:u:w:", ["verbose","help",
                                                                   "piana-dbname=", "piana-dbhost=", "piana-dbuser=", "piana-dbpass=" ])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
     
    for option,value in opts:
        
         if option in ("-t", "--taxonomy-file"):
             taxonomy_file = value
            
         elif option in ("-n", "--piana-dbname"):
             piana_dbname = value
             
         elif option in ("-o", "--piana-dbhost"):
             piana_dbhost = value
            
         elif option in ("-u", "--piana-dbuser"):
             piana_dbuser = value
             
         elif option in ("-w", "--piana-dbpass"):
             piana_dbpass = value
             
         elif option in ("-v", "--verbose"):
             verbose = 1
         elif option in ("-h", "--help"):
             # print help information and exit
             usage()
             sys.exit(2)
        
# --------
# --------
#  Main()               
# --------                               
# --------

piana_dbname = None
piana_dbuser = None
piana_dbhost = None
piana_dbpass = None

# parsing arguments from the command line
parseArguments()

# Initialisating connection to piana
piana_access = PianaDBaccess(dbname=piana_dbname, dbhost=piana_dbhost, dbuser=piana_dbuser, dbpassword= piana_dbpass)


"""
comparing ste20 exp ints with predicted ints
"""

piana_graph = PianaGraph("clustering level 1", piana_access_object= piana_access)

"""
node1 = GraphNode(nodeID="1")
node2 = GraphNode(nodeID="2")

attribute1 = PianaGraphNodeAttribute(proteinPiana_value=1, piana_access=piana_access)
attribute2 = PianaGraphNodeAttribute(proteinPiana_value=2, piana_access=piana_access)


node1.set_attribute(attribute1)
node2.set_attribute(attribute2)

edge1_2 = GraphEdge(node1_id=1, node2_id=2, graph=piana_graph)

piana_graph.add_node(node1)
piana_graph.add_node(node2)
piana_graph.add_edge(edge1_2)

print piana_graph.get_node_ids_list()
print piana_graph.get_edge_ids_list()

print piana_graph

"""


query_protein = 11694  # very small network: result of clustering must yield a network with 7 nodes (1 for all 11???? and 6 for the rest)

# 127569,136140 --> two proteins that produce a huge network



piana_builder = PianaGraphBuilder(piana_access_object=piana_access,
                                   depth= 2,
                                   hub_threshold= 0,
                                   list_protein_codes = [query_protein],
                                   code_type_name= "proteinPiana" )

piana_graph.build_graph(piana_builder)

#sys.stderr.write(piana_graph.get_connecting_nodes_dic(query_protein))

#grafo_original=piana_graph.output_interactions(protein_type_name="proteinPiana",
#                                               output_target=sys.stdout,
#                                               output_format="dot")

cluster=Clustering()

stop_cond=TestStopCondition()

sim_fun = TestSimilarityFunction(dbaccess= None)


clustered_graph=cluster.cluster_graph(graph_to_cluster=piana_graph, similarity_function=sim_fun, stop_condition=stop_cond)

clustered_graph.output_dot_file(output_target=sys.stdout)


clustered_graph.print_cluster_composition()
