"""
File        : ClusteredGraphGenerator.py
Author      : Ramon Aragues
Creation    : 07.2.2006
Contents    : returns an empty GraphCluster (or a child class)
Called from : Clustering.py

=======================================================================================================
"""

# ClusteredGraphGenerator.py: returns an empty GraphCluster (or a child class)
#
# Copyright (C) 2005  Ramon Aragues (University Pompeu Fabra)
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

from GraphCluster import *
from GraphClusterNodeAttribute import *

from CirGraphCluster import *
from CirGraphClusterNodeAttribute import *


verbose= 0

#------------------------------------------------------------------------------------------------
class ClusteredGraphGenerator(object):
#------------------------------------------------------------------------------------------------
    """
    Implements a class that returns an empty GraphCluster (or child class)

    It is used to allow the user to set which type of GraphCluster will be used for the clustering

    This is the default class. If you do not want to use GraphCluster for the Clustering, you must
    overwrite this class with a new method get_new_graph_cluster()
    """

    def get_new_graph_cluster(self):
        return GraphCluster()
    
    def get_new_graph_cluster_node_attribute(self):
        return GraphClusterNodeAttribute()

    
#------------------------------------------------------------------------------------------------
class CirClusteredGraphGenerator(object):
#------------------------------------------------------------------------------------------------
    """
    Implements a class that returns an empty GraphCluster (or child class)

    It is used to allow the user to set which type of GraphCluster will be used for the clustering

    This is the default class. If you do not want to use GraphCluster for the Clustering, you must
    overwrite this class with a new method get_new_graph_cluster()
    """

    def get_new_graph_cluster(self):
        return CirGraphCluster()
    
    def get_new_graph_cluster_node_attribute(self):
        return CirGraphClusterNodeAttribute()


    
