"""
File        : GoClusteringStopCondition.py
Author      : Pablo Boixeda & Ramon Aragues
Creation    : 6.2005
Contents    : Stop condition to determine when to stop go clustering
Called from : Class that clusters using go

=======================================================================================================
"""

# GoClusteringStopCondition.py: implements a class for managing graphs
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

from ClusteringStopCondition import *
from GoClusteringSimilarityFunction import *

#--------------------------------------------------------------------------------------------
class GoClusteringStopCondition(ClusteringStopCondition):
    """
    Stop condition to determine when to stop go clustering
    """

    def __init__(self, highest_depth=None, go_similarity_function=None,coeficient=None):
        """
        """
        self.highest_depth= highest_depth  # highest depth we want to cluster
        self.go_similarity_function=go_similarity_function
        self.max_value=coeficient

    def condition_is_met(self):
        """
        method specific to Go. E.g if all values in similarity matrix lower than 1, then stop condition is met

        This method returns true if stop condition is met. False otherwise.

        We use the similarity matrix to calculate if the clustering must stop or not.
        """

        if verbose:
            sys.stderr.write("checking stop condition: highest depth reached = %s (limit %s) and max value = %s (limit %s)\n" %(
                self.go_similarity_function.get_highest_depth(),
                self.highest_depth ,
                self.go_similarity_function.get_max_value(),
                self.max_value))

        if (self.go_similarity_function.get_highest_depth() <= self.highest_depth) or (self.max_value > self.go_similarity_function.get_max_value() ) :
            return True
        else:
            return False
    

    

    
