"""
File        : TestStopCondition.py
Author      : Pablo Boixeda & Ramon Aragues
Creation    : 4.2005
Contents    : Stop Condition example
Called from : 

=======================================================================================================
"""

# TestStopCondition.py:
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues

from ClusteringStopCondition import *

#--------------------------------------------------------------------------------------------
class TestStopCondition(ClusteringStopCondition):
    """
    Stop Condition example
    """

    def __init__(self,test_similarity_function=None):
        self.similarity_function=test_similarity_function

    def condition_is_met(self):
        """
        This method returns true if stop condition is met. False otherwise.

        We use the similarity matrix to calculate if the clustering must stop or not.
        """
        similarity_matrix=self.similarity_function.similarity_matrix
        for i in range(len(self.similarity_function.similarity_matrix)):                
                for j in range(i+1, len(self.similarity_function.similarity_matrix)):
                    if similarity_matrix[i][j] > 0:
                        return False
        return True
