"""
File        : GoGraphNodeAttribute.py
Author      : Pablo Boixeda & Ramon Aragues
Creation    : 7.2005
Contents    : class GoGraphNodeAttribute (attribute specific to GO for a Node)
Called from : 

=======================================================================================================

Implements the attribute for a node in a GoGraph object   
"""

# GoGraphNodeAttribute.py : Implements the attribute for a node in a GoGraph object   
#
# Copyright (C) 2005  Ramon Aragues
# author email: ramon.aragues@upf.edu and boliva@imim.es
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#    http://www.gnu.org/copyleft/gpl.html
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# University Pompeu Fabra, hereby disclaims all copyright
# interest in the program 'PIANA'
# (software for working with protein-protein interaction networks) written 
# by Ramon Aragues


from GraphNodeAttribute import *
from PianaDB import *

#---------------------------------------------------------------
class GoGraphNodeAttribute(GraphNodeAttribute):
#---------------------------------------------------------------
    

    def __init__(self, proteinPiana_value = None, term_id_value = None, name = None, is_root_value = None):

        """
        "proteinPiana_value" is the proteinPiana of this node

        "term_id_value" id the term id associated to the proteinPiana

        "term_type" is the molecular function, cellular component or biological process associated to this term_id
        """

        self.proteinPiana = proteinPiana_value
        self.term_id= term_id_value
        self.name=name
        self.is_root=is_root_value

    def get_node_id(self):
        """
        overwrittes the method in GraphNodeAttribute, identifying this attribute with the proteinPiana
        """
        return self.proteinPiana
    
    def get_proteinPiana(self):
        return self.proteinPiana

    def get_proteinPiana(self):
        return self.proteinPiana

    def get_go_name(self):
        return self.name

    def get_is_root(self):
        return self.is_root

    def get_term_id(self):
        return self.term_id



