C     Collection of subroutines implementing numerically intensive
C     graph algorithms. Designed to be callable from Graph.py

      subroutine connect(a,n,c)

C     Given the adjacency matrix a(n,n) returns the connectivity matrix c(n,n)

      implicit none

      integer n
      integer a(n,n),c(n,n)

Cf2py intent(in) :: a
Cf2py intent(in) :: n
Cf2py intent(out) :: c

      integer i,j,k,iter,i_flag,k_sum

C     initialise c
      do i=1,n
         do j=1,n
            c(j,i) = a(j,i)
         end do
         c(i,i) = 1
      end do

C     start the main loop
      do iter=1,n
         i_flag = 0
C     loop through the upper half
         do i=1,n-1
            do j=i+1,n
C     test value and if 0 do matrix multiply
               if(c(j,i) .eq. 0) then
                  k_sum = 0
                  do k=1,n
                     k_sum = k_sum + (c(k,i) * c(k,j))
                  end do
                  if(k_sum .gt. 0) then
                     i_flag = 1
                     c(i,j) = 1
                     c(j,i) = 1
                  end if
               end if
            end do
         end do

C     break if nothing has been done in the last iteration
         if(i_flag .eq. 0) goto 100

      end do

 100  continue

      end subroutine


      subroutine is_fully_connected(c,n,i_connect)
     
      implicit none

      integer n, i_connect
      integer c(n,n)

Cf2py intent(in) :: n
Cf2py intent(in) :: c
Cf2py intent(out) :: i_connect

      integer i,j

      i_connect = 1

      do i=1,n-1
         do j=i+1,n
            if(c(j,i) .eq. 0) then
               i_connect = 0
               goto 200
            end if
         end do
      end do

 200  continue

      end subroutine


      subroutine nodes_connected(a,n,i_node_a,i_node_b,i_connect)

C     Given an adjacency matrix, returns 1 if the two nodes i_node_a and i_node_b
C     are connected

      implicit none

      integer n, i_node_a, i_node_b, i_connect
      integer a(n,n)

      integer c(n,n)

Cf2py intent(in) :: n
Cf2py intent(in) :: i_node_a
Cf2py intent(in) :: i_node_b
Cf2py intent(in) :: c
Cf2py intent(out) :: i_connect

      integer i,j

C     Initialise
      do i=1,n
         do j=1,n
            c(j,i) = 0
         end do
      end do

      call connect(a,n,c)

      if(c(i_node_a,i_node_b) .eq. 1) then
         i_connect = 1
      else
         i_connect = 0
      end if

      end subroutine

      
      subroutine gen_degree(a,n,k)

C     returns a vector of nodal degrees

      implicit none

      integer n
      integer a(n,n), k(n)

Cf2py intent(in) :: n
Cf2py intent(in) :: a
Cf2py intent(out) :: k

      integer i,j

      do i=1,n
         k(i) = 0
         do j=1,i-1
            k(i) = k(i) + a(j,i)
         end do
         do j= i+1, n
            k(i) = k(i) + a(j,i)
         end do
      end do

      end subroutine

      subroutine ave_degree(k,n,degree)

      integer n
      integer k(n)
      real degree

Cf2py intent(in) :: n
Cf2py intent(in) :: k
Cf2py intent(out) :: degree

      integer i

      degree = 0.0

      do i=1,n
         degree = degree + real(k(n))
      end do

      degree = degree / real(n)

      end subroutine

      subroutine calc_clus_coef(a,n,c,ave_c)

      implicit none

      integer n
      integer a(n,n)
      real c(n)
      real ave_c

Cf2py intent(in) :: n
Cf2py intent(in) :: a
Cf2py intent(out) :: c
Cf2py intent(out) :: ave_c
      
      integer i,j,i_node,n_neigh,kv,two_e

C     initialise
      do i=1,n
         c(i) = 0.0
      end do
      ave_c = 0.0

C     start main loop
      do i_node=1,n
C     find number of neighbours
         n_neigh = 0
         do i=1,n
            n_neigh = n_neigh + a(i,i_node)
         end do
         two_e = 2* n_neigh
         kv = n_neigh + 1
         do i=1,n
            if(a(i,i_node) .eq. 1) then
               do j=1,n
                  if( (a(j,i).eq.1) .AND. (a(j,i_node).eq.1)) then
                     two_e = two_e + 1
                  end if
               end do
            end if
         end do
         c(i_node) = two_e / real(kv*(kv-1))
         ave_c = ave_c + c(i_node)
      end do

      ave_c = ave_c / real(n)

      end subroutine


      subroutine nerfcm_cluster(dist,n,n_clus,v)

      implicit none

      integer n,n_clus
      real dist(n,n)
      real v(n_clus,n)

Cf2py intent(in) :: n
Cf2py intent(in) :: n_clus
Cf2py intent(in) :: dist
Cf2py intent(out) :: v

      integer i,j,k,i_iter,mx_iter
      real u_init(n_clus,n),u(n_clus,n),d(n_clus,n)
      real beta,epsilon,step_size,work

      parameter(mx_iter=1000)
      parameter(epsilon=0.0001)


C     initialise data
      step_size = epsilon
      beta = 0
      do i=1,n
         do j=1,n_clus
            u(j,i) = u_init(j,i)
         end do
      end do

C     start main loop
      do i_iter=1,mx_iter

C     initialise new prototypes
         do i=1,n
            do j=1,n_clus
               u_init(j,i) = u(j,i)
            end do
         end do

         do i=1,n_clus
            work = 0.0
            do j=1,n
               v(i,j) = u_init(j,i) * u_init(j,i)
               work = work + v(i,j)
            end do
            do j=1,n
               v(i,j) = v(i,j)/work
            end do
         end do

C     get d value
C     this bit here is just a matrix multiply - ouch!
         do i=1,n
            do j=1,n_clus
               d(j,i) = 0.0
               do k=1,n
                  d(j,i) = d(j,i) + (v(j,k) * dist(k,i))
               end do
            end do
         end do

         do i=1,n_clus
            work = 0.0
            do j=1,n
               work = work + v(i,j)*d(i,j)
            end do
            work = work / 2.0
            do j=1,n
               d(i,j) = d(i,j) - work
            end do
         end do

C     adjust negative values for d

         
C     adjust low d values
         do i=1,n
            do j=1,n_clus


               if(step_size .lt. epsilon) goto 500
            end do
         end do

      end do

 500  continue


      end subroutine
