# File     : create_dip_tables.sql
# Author   : Ramon Aragues
# Creation : 18.11.2003
# Contents : script that creates the tables of a dip database 
# Usage    : mysql --host=sefarad --database=dipDB_name < create_dip_tables.sql
# Comments :
#
# Execution of this script creates tables for a dip database.
#
# Previously, the database dipDB_name must have been created
#
# Before creating tables, if we are working with an existing database, you have to run drop_dip_tables.sql


# ------------------------------------------------------------------
# Create table nodes
# ------------------------------------------------------------------
# This table will hold all the nodes and their information
# ------------------------------------------------------------------
# 
# The unique identifier is node_uid! node_id changes across different
# distributions of DIP
#

CREATE TABLE nodes (
       node_id integer NOT NULL,
       node_uid character varying (20) NOT NULL,
       node_name character varying (20),
       node_class character varying (20),
       node_organism character varying (50),
       node_taxonomy integer,
       node_description character varying (255),

       index(node_uid),

       primary key(node_uid)
);

# ------------------------------------------------------------------
# Create table nodes_ext_names
# ------------------------------------------------------------------
# This table will hold all the nodes and their information
# ------------------------------------------------------------------

CREATE TABLE nodes_ext_names (
       node_ext_id integer NOT NULL,
       node_ext_uid integer NOT NULL,
       node_ext_name character varying (20),
       node_ext_sprot character varying (20),
       node_ext_pir character varying (20),
       node_ext_refseq character varying (20),
       node_ext_gi integer,

       index(node_ext_id),
       index(node_ext_sprot),
       index(node_ext_pir),
       index(node_ext_refseq),
       index(node_ext_gi),

       primary key(node_ext_uid)

       
);

# ------------------------------------------------------------------
# Create table edges
# ------------------------------------------------------------------
# This table will hold all the nodes and their information
# ------------------------------------------------------------------
# 
# The unique identifier is edge_uid! node_id changes across different
# distributions of DIP
#

CREATE TABLE edges (
       edge_id integer NOT NULL,
       edge_uid character varying (20) NOT NULL,
       edge_from integer NOT NULL,
       edge_to integer NOT NULL,
       edge_class character varying (20),

       index(edge_uid),
       index(edge_from),
       index(edge_to),

       primary key(edge_uid)
);

# ------------------------------------------------------------------
# Create table edges_experiments
# ------------------------------------------------------------------
# This table will hold all the nodes and their information
# ------------------------------------------------------------------

CREATE TABLE edges_experiments (
       edge_exp_id integer NOT NULL,
       edge_exp_uid character varying (20) NOT NULL,
       edge_exp_source character varying (20),
       edge_exp_name character varying (40),

       index(edge_exp_uid),

       primary key(edge_exp_uid)
);

