# File     : create_psi_tables.sql
# Author   : Ramon Aragues
# Creation : 19.10.2005
# Contents : script that creates the tables of a psi database 
# Usage    : mysql --host=sefarad --database=your_psiDB_name < create_psi_tables.sql
# Comments :
#
# Execution of this script creates tables for a psi database (eg mipsDB_20051001)
#
# This is a simplified generic version of a database for data extracted from PSI files
# it can be used to store information from any data in PSI format (eg, mips, hprd, bind, ...)
#
# Previously, the database psiDB_name  (eg mipsDB_20051001) must have been created
#
# Before creating tables, if we are working with an existing database, you have to run drop_psi_tables.sql


# ------------------------------------------------------------------
# Create table proteins
# ------------------------------------------------------------------
# This table will hold all the proteins and their information
# ------------------------------------------------------------------
# 
# db_id refers to the internal identifier used in a particular db for a protein
#     --> in BIND and MIPS this id is set to "irrelevant"
#
# Attention! counter_ids inserted as protein identifiers for BIND and MIPS do not mean anything! They are just used
#           in the psi database to index the interactions, but one counter id is only used for one interaction,
#           and one protein code can have multiple counter ids (one for each interaction where that protein appears)

CREATE TABLE proteins (
       counter_id integer unsigned AUTO_INCREMENT,
       db_id character varying (100) NOT NULL,

       index(db_id),

       primary key (counter_id)	
);

CREATE TABLE proteinCodes (
       counter_id integer,
       sequence mediumtext,
       description character varying (255),
       spAcc_id character varying (20),
       emblAcc_id character varying (20),
       gi_id character varying (20),

       index(counter_id),
       index(spAcc_id),
       index(gi_id),
       index(emblAcc_id)
);

CREATE TABLE proteinFeatures (
       counter_id integer,
       organism character varying (255),
       tax_id integer,

       index(counter_id),
       index(tax_id)
);


# ------------------------------------------------------------------
# Create table interactions
# ------------------------------------------------------------------
# This table will hold all the nodes and their information
# ------------------------------------------------------------------
# 
# interaction_key is a string proteinA.proteinB where proteinA < proteinB
#

CREATE TABLE interactions (
       interaction_key character varying(40) NOT NULL,
       proteinA_counter_id  integer unsigned NOT NULL,
       proteinB_counter_id  integer unsigned NOT NULL,

       index(proteinA_counter_id),
       index(proteinB_counter_id),

       primary key(interaction_key)
);


CREATE TABLE interactionFeatures (
       interaction_key character varying (20) NOT NULL,
       pubmed_id character varying (20),

       index(interaction_key)
);
       

CREATE TABLE interactionMethod (
       interaction_key character varying(40) NOT NULL ,
       method character varying (50),

       index(interaction_key)

);



