"""
File        : delete_interactions_with_no_db_source.py
Author      : Ramon Aragues
Creation    : 16.11.2004
Contents    : script that deletes interactions from piana databases that do not have a source db associated
Called from : 

=======================================================================================================

This program deletes interaction entries from piana databases that do not have a source db associated

"""

import sys
import getopt

import re
import readline

import MySQLdb

from PianaDBaccess import *

verbose = 1



# ----------------------
# Function usage()
# ----------------------
def usage():
    print "--------------------------------------------------------------------------------------------------------------"
    print "This program deletes specific interactions from piana databases\n"
    print "Usage: python delete_interactions_with_no_db_source.py"
    print "           --piana-dbname=piana_dbname --piana-dbhost=piana_dbhost --piana-dbuser=piana_dbuser --piana-dbpass=piana_dbpass  [--help] [--verbose]"
    print "\nwhere:"
    print "     piana_dbname : name of database piana to be used (required)"
    print "     piana_dbhost : name of host where database piana to be used is placed (required)"
    print "     piana_dbuser : username accessing the database (not required in most systems)"
    print "     piana_dbpass : password of username accessing the database (not required in most systems)"
    print "     --help         : prints this message and exits"
    print "     --verbose      : prints process info to stdout"
    print "--------------------------------------------------------------------------------------------------------------"
        

   
# ---------------------------
# Function parseArguments()                                               
# --------------------------- 

def parseArguments():
    
    global piana_dbname
    global piana_dbhost
    global piana_dbuser
    global piana_dbpass

    global verbose
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "vhf:d:t:n:o:u:w:", ["verbose","help",
                                                                      "piana-dbname=", "piana-dbhost=", "piana-dbuser=", "piana-dbpass="])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
     
    for option,value in opts:
        
        if option in ("-n", "--piana-dbname"):
            piana_dbname = value
            
        elif option in ("-o", "--piana-dbhost"):
            piana_dbhost = value
            
        elif option in ("-u", "--piana-dbuser"):
            piana_dbuser = value
            
        elif option in ("-w", "--piana-dbpass"):
            piana_dbpass = value
            
        elif option in ("-x", "--verbose"):
            verbose = 1
            
        elif option in ("-h", "--help"):
            # print help information and exit
            usage()
            sys.exit(2)
             
    # END OF for option,value in opts:
       
        
        
# --------
# --------
#  Main()               
# --------                               
# --------

piana_dbname = None
piana_dbuser = None
piana_dbhost = None
piana_dbpass = None

# parsing arguments from the command line
parseArguments()

# Initialisating connection to piana
piana_access = PianaDBaccess(dbname=piana_dbname, dbhost=piana_dbhost, dbuser=piana_dbuser, dbpassword= piana_dbpass)

number_of_interactions_deleted = 0
sqlquery = """ SELECT interactionPiana from interaction """

for interactionPiana in piana_access.db.select_db_content(sqlquery, answer_mode = "list"):

    list_source_db = piana_access.get_interaction_sourceDB_list( interactionPiana_value= interactionPiana)
    
    if not list_source_db:
        sys.stderr.write("Deleting interactionPiana %s\n" %(interactionPiana))
        piana_access.delete_interaction(interactionPiana_value = interactionPiana)
        number_of_interactions_deleted += 1
    
# END OF for interactionPiana in all_interactionPiana:


sys.stderr.write("Number of interactions deleted: %s\n" %(number_of_interactions_deleted))

