/*
 */

import com.hp.hpl.jena.ontology.*;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

import java.io.FileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.*;
import java.util.HashSet;
import java.util.regex.*;


public class PathwayExtractor
{                                    
    public static final String BP = "http://www.biopax.org/release/biopax-level2.owl#";

    public static HashSet sub_pathways = new HashSet();

    public static void main(String args[]) throws FileNotFoundException
    {
        OntModel model = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        model.read(new FileInputStream(new File("./human_reactome.owl")), "");

        // grab everthing you need
        OntClass pathwayClass = model.getOntClass(BP + "pathway");
        OntProperty pathwayComponents = model.getOntProperty(BP + "PATHWAY-COMPONENTS");
        OntProperty stepInteractions = model.getOntProperty(BP + "STEP-INTERACTIONS");
        OntProperty participants = model.getOntProperty(BP + "PARTICIPANTS");
        OntProperty par_right = model.getOntProperty(BP + "RIGHT");
        OntProperty par_left = model.getOntProperty(BP + "LEFT");
        OntProperty par_controller = model.getOntProperty(BP + "CONTROLLER");
        OntProperty par_controlled = model.getOntProperty(BP + "CONTROLLED");
        OntProperty par_cofactor = model.getOntProperty(BP + "COFACTOR");
        OntProperty physicalEntity = model.getOntProperty(BP + "PHYSICAL-ENTITY");
        OntProperty name = model.getOntProperty(BP + "NAME");
        OntProperty xref = model.getOntProperty(BP + "XREF");
        OntProperty db_property = model.getOntProperty(BP + "DB");
        OntProperty id_property = model.getOntProperty(BP + "ID");
        OntProperty components = model.getOntProperty(BP + "COMPONENTS");

        //iterate over pathways so we can know which pathways are actuall subpathways
	//  -> then, we will only print the name of the pathway if it is a level 1 pathway
        ExtendedIterator pathwayIterator = pathwayClass.listInstances();

	//Integer i = 0;

        while (pathwayIterator.hasNext())
        {
	    //System.out.println("pathway_num=" + i);
	    //i ++;

            Individual pathway = (Individual) pathwayIterator.next();
            NodeIterator nodeIterator =  pathway.listPropertyValues(pathwayComponents);
	    
	    //Integer j = 0;
            //iterate over components
            while (nodeIterator.hasNext())
            {

		//System.out.println("   -> component_num=" + j);
		//j++;

                NodeIterator interactionIterator = extractIndividual(nodeIterator.next()).listPropertyValues(stepInteractions);
		
		//Integer k = 0;
                // iterate over interactions
                while (interactionIterator.hasNext())
                {
                    Individual suspectedPathway = extractIndividual(interactionIterator.next());
		    
		    String pathway_type= suspectedPathway.getRDFType().toString();
		    //System.out.println("         -> stepInteraction_num=" + k + " of type=" + pathway_type );
		    //k++;
  
                    if ( pathway_type.equals(BP + "pathway") )
			{
			    //System.out.println("             -> is pathway" ); 
			    String pathway_name = return_first_element(suspectedPathway.getPropertyValue(name));
			    //System.out.println("                   -> pathway_name=" + pathway_name );
			    sub_pathways.add( pathway_name );
			}
		    else
			{
			    //System.out.println("             -> Not pathway" ); 
			}
                }
            }
        }

	//System.out.println("SUBPATHWAYS=" + sub_pathways);


	// -------------------------------------------------------------------------------
	// now, iterate over all the patways and retrieve the proteins involved in them
	//   -> do it only for pathways that are not subpathways of others
	//   -> subpathways are processed as pathway steps and their proteins assigned to the level 1 pathway
	// -------------------------------------------------------------------------------

        pathwayIterator = pathwayClass.listInstances();

        while (pathwayIterator.hasNext())
        {
            Individual pathway = (Individual) pathwayIterator.next();
	    String this_pathway_name = return_first_element( pathway.getPropertyValue(name) );
	    if (!sub_pathways.contains(this_pathway_name))
		// If the pathway is not a subpathway of another pawthway, then process it.
            {
		// create a file name for this pathway
		Pattern this_pattern = Pattern.compile("[\\p{Punct} ]+");
		Matcher this_matcher = this_pattern.matcher(this_pathway_name);
		String pathway_file_name = this_matcher.replaceAll("_");

		// Create a new file output stream in which we will write the pathway proteins
		FileOutputStream out = new FileOutputStream(pathway_file_name + ".pathway_proteins");

		// Connect print stream to the output stream
		PrintStream pathway_fd = new PrintStream( out );
		
                System.out.println("=================================================================\n" + "pathway_name=" +  this_pathway_name);
                processPathway(pathway, pathway_fd, pathwayComponents, stepInteractions, participants, physicalEntity, name, xref, db_property, id_property, 
			       par_right, par_left, par_controlled, par_controller, par_cofactor, components);

		pathway_fd.close();
            }
        }
    }

    private static void processPathway(Individual pathway,
				       PrintStream pathway_fd,
                                       OntProperty pathwayComponents,
                                       OntProperty stepInteractions,
                                       OntProperty participants,
                                       OntProperty physicalEntity,
                                       OntProperty name,
                                       OntProperty xref,
				       OntProperty db_property,
				       OntProperty id_property,
				       OntProperty par_right,
				       OntProperty par_left,
				       OntProperty par_controlled,
				       OntProperty par_controller,
				       OntProperty par_cofactor,
				       OntProperty components)
    {
        NodeIterator nodeIterator = pathway.listPropertyValues(pathwayComponents);

        //iterate over pathway components
        while (nodeIterator.hasNext())
        {

            NodeIterator interactionAndPathwayIterator = extractIndividual(nodeIterator.next()).listPropertyValues(stepInteractions);

            //iterate over stepInteractions

            while (interactionAndPathwayIterator.hasNext())
            {
		// elements of interactionAndPathwayIterator can be pathway, pathwayStep (pathway or multiple interactions) or multiple interactions
                Individual interactionOrPathway = extractIndividual(interactionAndPathwayIterator.next());


                if (interactionOrPathway.getRDFType().toString().equals(BP + "pathway"))
		    // if it is a pathway, recursively call this method until something else is found
                {
		    //		    System.out.println("    --> processing a subpathway of this pathway");
                    processPathway(interactionOrPathway,  pathway_fd, pathwayComponents, stepInteractions, participants, physicalEntity, name, xref, db_property, id_property, 
				   par_right, par_left, par_controlled, par_controller, par_cofactor, components);
                }
                
                else
                {

		    //System.out.println("    --> processing an interaction of this pathway of type: "  + interactionOrPathway.getRDFType().toString());
		    //RDFNode this_int_name = interactionOrPathway.getPropertyValue(name);
		    //if (this_int_name != null)
		    //	{
		    //    System.out.println("                                                  of name: "  + return_first_element(this_int_name));
		    //}

		    //		    System.out.println("       -> participants");
                    processInteraction( pathway_fd, interactionOrPathway, participants, physicalEntity, name, xref, db_property, id_property, components);
		    //		    System.out.println("       -> par_right");	
		    processInteraction( pathway_fd, interactionOrPathway, par_right, physicalEntity, name, xref, db_property, id_property, components);
		    //		    System.out.println("       -> par_left");	
		    processInteraction( pathway_fd, interactionOrPathway, par_left, physicalEntity, name, xref, db_property, id_property, components);
		    //		    System.out.println("       -> par_controller");	
		    processInteraction( pathway_fd, interactionOrPathway, par_controller, physicalEntity, name, xref, db_property, id_property, components);
		    //		    System.out.println("       -> par_controlled");	
		    processInteraction( pathway_fd, interactionOrPathway, par_controlled, physicalEntity, name, xref, db_property, id_property, components);
		    //		    System.out.println("       -> par_cofactor");	
		    processInteraction( pathway_fd, interactionOrPathway, par_cofactor, physicalEntity, name, xref, db_property, id_property, components);

                }
            }

        }
    }

    //ExtendedIterator subPropertyIterator = participants.listSubProperties();
    //while (subPropertyIterator.hasNext())
    //{
    //    System.out.println("                ==> subproperty found" );
    //    
    //    OntProperty subParticipants = (OntProperty) ((Resource) subPropertyIterator.next()).as(OntProperty.class);
    //}


    private static void processInteraction( PrintStream pathway_fd,
					    Individual interaction,
                                            OntProperty participants,
                                            OntProperty physicalEntity,
                                            OntProperty name,
					    OntProperty xref,
					    OntProperty db_property,
					    OntProperty id_property,
					    OntProperty components)
    {

        NodeIterator participantIterator =  interaction.listPropertyValues(participants);  // get the participants in this interaction

        while (participantIterator.hasNext())
        {
	    Individual participant =  extractIndividual(participantIterator.next());
	    //	    System.out.println("           -participant:" + participant.getRDFType().toString());

	    RDFNode pEResource = participant.getPropertyValue(physicalEntity);
	    
	    if (pEResource != null)
            {
		//		System.out.println("               -> direct pE  ");
		process_physical_entity( pathway_fd, pEResource, name, xref, db_property, id_property, components, physicalEntity);

		//		System.out.println("               -> components pE  ");
		process_components( pathway_fd, pEResource,  name, xref, db_property, id_property, components, physicalEntity);
		
	    }
        }
    }
    
    private static void process_components(PrintStream pathway_fd,
					   RDFNode pE, OntProperty name, OntProperty xref, OntProperty db_property, 
					   OntProperty id_property, OntProperty components, OntProperty physicalEntity)
    {	
	Individual componentsInd = extractIndividual(pE);
	NodeIterator pEIterator =  componentsInd.listPropertyValues(components);
	
	while (pEIterator.hasNext())
	    {
		Individual one_component_ind = extractIndividual(pEIterator.next());
		//		System.out.println("             - one_component:" + one_component_ind.getRDFType().toString());
		RDFNode comp_pEResource = one_component_ind.getPropertyValue(physicalEntity);

		process_physical_entity( pathway_fd, comp_pEResource , name, xref, db_property, id_property, components, physicalEntity);
	    }

    }

    private static void process_physical_entity(PrintStream pathway_fd,
						RDFNode pE, OntProperty name, OntProperty xref, OntProperty db_property, 
						OntProperty id_property, OntProperty components, OntProperty physicalEntity)
    {
	
	Individual physicalEntityInd = extractIndividual(pE);
	
	RDFNode nameNode = physicalEntityInd.getPropertyValue(name);

	//if (nameNode != null)
	//  {
	//System.out.println("                  ***node_name=" + return_first_element(nameNode));
	//  }
	
	NodeIterator xrefIterator =  physicalEntityInd.listPropertyValues(xref);
	
	while (xrefIterator.hasNext())
	    {
		Individual one_xref =  extractIndividual(xrefIterator.next());	
		
		RDFNode db_name = one_xref.getPropertyValue(db_property);
		RDFNode id_value = one_xref.getPropertyValue(id_property);
		System.out.println("xref_" + return_first_element(db_name) + "=" + return_first_element(id_value));

		if (return_first_element(db_name).equals("UniProt"))
		    // printing to file only if it is a UniProt protein identifier
		    {
			pathway_fd.println(return_first_element(id_value));
		    }
	    }
	// now, check if this pE has components itself (eg. it is a complex)
	
	//	System.out.println("                    -> subcomponents pE  ");
		
	process_components( pathway_fd, pE,  name, xref, db_property, id_property, components, physicalEntity);
	      	
    }

    private static Individual extractIndividual(Object o)
    {
        return (Individual) ((Resource) o).as(Individual.class);
    }

    private static String return_first_element(RDFNode s)
    {
        return (s.toString()).split("\\^\\^")[0];
    }

}

