# This file is used to get specific interactions from dip database
#
# You can alternatively use get_interactions_from_dipDB.py
# 
# Usage:  mysql --host=sefarad.imim.es --database=dipDB  --silent < get_specific_dip_interactions.sql
# Comments: --silent removes headers with column names

# change the sql statement to get the interactions you need

# ---------------
# this sql statement gets all Caenorhabditis elegans interactions in format edge_from_dip_id<TAB>edge_to_dip_id
# ---------------
#
#select edge_from, edge_to from edges, nodes n1, nodes n2 where edge_from=n1.node_id and edge_to=n2.node_id and n1.node_organism like "%Caenorhabditis elega%" a#nd n2.node_organism like "%Caenorhabditis elega%";
#
# ---------------
# this sql statement gets all Caenorhabditis elegans interactions in format edge_from_dip_uid<TAB>edge_to_dip_uid
# ---------------
#
#select n1.node_uid, n2.node_uid from edges, nodes n1, nodes n2 where edge_from=n1.node_id and edge_to=n2.node_id and n1.node_organism like "%Caenorhabditis ele#ga%" and n2.node_organism like "%Caenorhabditis elega%";

# ---------------
# this sql statement gets all DIP interactions in format edge_from_dip_uid<TAB>edge_to_dip_uid
# ---------------
#
#select n1.node_uid, n2.node_uid from edges, nodes n1, nodes n2 where edge_from=n1.node_id and edge_to=n2.node_id;

# ---------------
# this sql statement gets all DIP node_uids next to their external codes
# ---------------
#
select n.node_uid, n.node_name, e.node_ext_sprot, e.node_ext_pir, e.node_ext_refseq, e.node_ext_gi  from nodes n, nodes_ext_names e where n.node_uid=e.node_ext_uid;
